define(['angular', 'angularMocks', 'AssessmentBuilderListViewController', 'angularUiBootstrap'], function(angular, mocks) {
    'use strict';

    describe("The Assessment Builder List View controller", function (){
        var controller, 
            scope,
            stateMock,
			focusServiceMock,
            globalDelayTrackerMock,
            previousStateMock,
            assessmentServiceMock,
            assessmentMock;

        beforeEach( function () {
            module('angularTemplateApp');

            assessmentMock = {
                data: {
                    assessment: [
                        {status: "Active"},
                        {status: "Draft"},
                        {status: "Draft"},
                        {status: "Inactive"},
                        {status: "Inactive"},
                        {status: "Inactive"},
                        {status: "Inactive"}
                    ]
                }
            };

            stateMock = jasmine.createSpyObj('$state', ['go']);
			focusServiceMock = jasmine.createSpyObj('focusService', ['focusMain']);
            globalDelayTrackerMock = jasmine.createSpyObj('globalDelayTracker', ['add', 'remove', 'active']);
            globalDelayTrackerMock.active.andCallFake(function(){
                return true;
            });
            previousStateMock = {};
            previousStateMock.isFirstAppRoute = true;
            assessmentServiceMock = jasmine.createSpyObj('assessmentService', ['getAssessments']);
            assessmentServiceMock.getAssessments.andCallFake(function() {
                return {
                    then: function(callback) {
                        callback(assessmentMock); 
                    }
                }
            }); 
            module(function($provide){
                $provide.value('$state', stateMock); 
				$provide.value('focusService', focusServiceMock);
                $provide.value('globalDelayTracker', globalDelayTrackerMock);
                $provide.value('previousState', previousStateMock);
                $provide.value('assessmentService', assessmentServiceMock); 
            });

            inject(function($controller, $rootScope) {
                scope = $rootScope.$new();
                controller = $controller('AssessmentBuilderListViewController', {$scope:scope});
            });
        });

        describe("when the page is loaded", function (){
            it("should get the assessments and filter active and draft assessments by default", function() {
                expect(assessmentServiceMock.getAssessments).toHaveBeenCalled();
                expect(scope.allAssessments).toEqual(assessmentMock.data.assessment);
                expect(scope.assessments.length).toBe(3);
            });
            it("should update the previous state and focus main when delay tracker resolves", function() {
                globalDelayTrackerMock.active = function() { return false; };
                scope.$apply();
                expect(focusServiceMock.focusMain).toHaveBeenCalled(); 
                expect(previousStateMock.isFirstAppRoute).toBe(false);
            });
        });

        describe("open assessment function", function() {
            it("should redirect to the assessment", function() {
                var assessment = {
                    item: {
                        id: '123'
                    }
                }
                scope.openAssessment(assessment);
                expect(stateMock.go).toHaveBeenCalled(); 
            });
        });

        describe("filter function", function() {
            it("should filter out the appropriate assessments based on the checkboxes", function() {
                scope.checkboxModel.active = false;
                scope.checkboxModel.draft = false;
                scope.checkboxModel.inactive = false;
                scope.filter();
                expect(scope.assessments.length).toBe(0);
                scope.checkboxModel.active = true;
                scope.filter();
                expect(scope.assessments.length).toBe(1);
                scope.checkboxModel.draft = true;
                scope.filter();
                expect(scope.assessments.length).toBe(3);
                scope.checkboxModel.inactive = true;
                scope.filter();
                expect(scope.assessments.length).toBe(7);
            }); 
        });

        describe("reset function", function() {
            it("should put the filter back to default choices", function() {
                scope.checkboxModel.active = false;
                scope.checkboxModel.draft = false;
                scope.checkboxModel.inactive = true;
                scope.reset();
                expect(scope.checkboxModel.active).toBe(true); 
                expect(scope.checkboxModel.draft).toBe(true); 
                expect(scope.checkboxModel.inactive).toBe(false); 
            });
        });
    });
});